CREATE or REPLACE PROCEDURE proc_create_result_report (v_StateName CHAR) IS

v_CountyName CHAR(30);
v_StateCode station.state_code%type;

CURSOR c_Counties IS
	SELECT unique(county_name) 
		FROM station 
		WHERE state_name = v_StateName;

BEGIN

OPEN c_Counties;

SELECT unique(state_code) INTO v_StateCode
FROM station
WHERE state_name = v_StateName;

LOOP
	FETCH c_Counties INTO v_CountyName;
	Exit WHEN c_Counties%NOTFOUND;
	dbms_output.enable(10000000);
	dbms_output.put_line('SPOOL H:/joe/'||TRANSLATE(TRIM(v_StateName), ' ', '_')||'/'||TRANSLATE(TRIM(v_StateCode), ' ', '_')||'_'||TRANSLATE(TRIM(v_CountyName), ' ', '_')||'_res.txt');
	dbms_output.put_line('SELECT STA.fk_agency_code, STA.primary_station_id, rtrim(STA.location_name)||'' / ''||rtrim(STA.location_name_2)||'' / ''||rtrim(STA.location_name_3) AS "Station Name",');
	dbms_output.put_line('STA.agency_name, STA.state_name, STA.county_name, STA.latitude,');
	dbms_output.put_line('CASE WHEN STA.longitude IS NULL THEN NULL ELSE ''-''||longitude END AS "long",RES.result_value, RES.fk_storet_result_remark_code,STA.fips_hydrologic_unit_code,RES.fk_parameter_code,');
	dbms_output.put_line('TO_CHAR(SAM.start_date,''YYYY-MM-DD'') AS "Start Date",CASE WHEN SAM.start_time=0 then null else start_time end AS "Start_Time2",TO_CHAR(SAM.end_date,''YYYY-MM-DD'') AS "End Date",');
	dbms_output.put_line('CASE WHEN SAM.end_time=0 then null else end_time end AS "End_Time2",SAM.sample_depth,SAM.umk,SAM.replicate_number,CASE WHEN end_date is null then null else RES.fk_composite_statistic_code END AS "csc",');
	dbms_output.put_line('SAM.composite_grab_number,SAM.fk_composite_method_code,PAC.name AS "Primary Activity Category",SAC.name AS "Secondary Activity Category"');
	dbms_output.put_line('FROM station STA, storet_owner.result RES, storet_owner.sample SAM,storet_owner.prmry_scndry_actvty_combo2 com2,'); 
	dbms_output.put_line('storet_owner.primary_activity_category pac,storet_owner.secondary_activity_category sac');
	dbms_output.put_line('WHERE STA.computer_sequence_number = SAM.fk_computer_sequence_number');
	dbms_output.put_line('and RES.fk_sample_code_isn = sAM.sample_code_isn');
	dbms_output.put_line('and SAM.fk_prmy_scndy_combo2_code_isn = com2.code_isn (+)');
	dbms_output.put_line('and com2.fk_prmry_actvty_category_code = pac.code (+)');
	dbms_output.put_line('and com2.fk_scndry_actvty_category_code = sac.code (+)');
	dbms_output.put_line('and STA.county_name = '''||trim(v_CountyName)||'''');
	dbms_output.put_line('and STA.state_name = '''||trim(v_StateName)||'''');
	dbms_output.put_line('ORDER BY fk_Parameter_code, fk_agency_code, primary_station_id, start_date;');
	dbms_output.put_line('SPOOL OFF');

END LOOP;
CLOSE c_Counties;

END;
/
SHOW ERRORS;